MODULE UBYTE pix[2][64][8] =
{ { { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, //  0 (space)
    { 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80 }, //  1 (/)
    { 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01 }, //  2 (\)
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }, //  3 (solid block)
    { 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, //  4
    { 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 }, //  5
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF }, //  6 (_)
    { 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0 }, //  7
    { 0xFF, 0xFF, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 }, //  8
    { 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0 }, //  9
    { 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xFF, 0xFF }, // 10
    { 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xFF, 0xFF }, // 11
    { 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF }, // 12
    { 0x80, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE, 0xFF }, // 13
    { 0xFF, 0xFE, 0xFC, 0xF8, 0xF0, 0xE0, 0xC0, 0x80 }, // 14
    { 0xFF, 0x7F, 0x3F, 0x1F, 0x0F, 0x07, 0x03, 0x01 }, // 15
    { 0x00, 0x1c, 0x22, 0x26, 0x2a, 0x32, 0x22, 0x1c }, // 16 0
    { 0x00, 0x08, 0x18, 0x08, 0x08, 0x08, 0x08, 0x1c }, // 17 1
    { 0x00, 0x1c, 0x22, 0x02, 0x0c, 0x10, 0x20, 0x3e }, // 18 2
    { 0x00, 0x3e, 0x02, 0x04, 0x0c, 0x02, 0x22, 0x1c }, // 19 3
    { 0x00, 0x04, 0x0c, 0x14, 0x24, 0x3e, 0x04, 0x04 }, // 20 4
    { 0x00, 0x3e, 0x20, 0x3c, 0x02, 0x02, 0x22, 0x1c }, // 21 5
    { 0x00, 0x0c, 0x10, 0x20, 0x3c, 0x22, 0x22, 0x1c }, // 22 6
    { 0x00, 0x7c, 0x02, 0x04, 0x08, 0x10, 0x10, 0x10 }, // 23 7
    { 0x00, 0x1c, 0x22, 0x22, 0x1c, 0x22, 0x22, 0x1c }, // 24 8
    { 0x00, 0x1c, 0x22, 0x22, 0x3e, 0x02, 0x04, 0x18 }, // 25 9
    { 0x00, 0x08, 0x14, 0x22, 0x22, 0x3e, 0x22, 0x22 }, // 26 A
    { 0x00, 0x3c, 0x22, 0x22, 0x3c, 0x22, 0x22, 0x3c }, // 27 B
    { 0x00, 0x1c, 0x22, 0x20, 0x20, 0x20, 0x22, 0x1c }, // 28 C
    { 0x00, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3c }, // 29 D
    { 0x00, 0x3e, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x3e }, // 30 E
    { 0x00, 0x3e, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x20 }, // 31 F
    { 0x00, 0x1e, 0x20, 0x20, 0x20, 0x26, 0x22, 0x1e }, // 32 G
    { 0x00, 0x22, 0x22, 0x22, 0x3e, 0x22, 0x22, 0x22 }, // 33 H
    { 0x00, 0x1c, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1c }, // 34 I
    { 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1c }, // 35 J
    { 0x00, 0x22, 0x24, 0x28, 0x30, 0x28, 0x24, 0x22 }, // 36 K
    { 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e }, // 37 L
    { 0x00, 0x22, 0x36, 0x2a, 0x2a, 0x22, 0x22, 0x22 }, // 38 M
    { 0x00, 0x22, 0x22, 0x32, 0x2a, 0x26, 0x22, 0x22 }, // 39 N
    { 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c }, // 40 O
    { 0x00, 0x3c, 0x22, 0x22, 0x3c, 0x20, 0x20, 0x20 }, // 41 P
    { 0x00, 0x1c, 0x22, 0x22, 0x22, 0x2a, 0x24, 0x1a }, // 42 Q
    { 0x00, 0x3c, 0x22, 0x22, 0x3c, 0x28, 0x24, 0x22 }, // 43 R
    { 0x00, 0x1c, 0x22, 0x20, 0x1c, 0x02, 0x22, 0x1c }, // 44 S
    { 0x00, 0x3e, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 }, // 45 T
    { 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1c }, // 46 U
    { 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x14, 0x08 }, // 47 V
    { 0x00, 0x22, 0x22, 0x22, 0x2a, 0x2a, 0x36, 0x22 }, // 48 W
    { 0x00, 0x22, 0x22, 0x14, 0x08, 0x14, 0x22, 0x22 }, // 49 X
    { 0x00, 0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08 }, // 50 Y
    { 0x00, 0x3e, 0x02, 0x04, 0x08, 0x10, 0x20, 0x3e }, // 51 Z
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08 }, // 52 .
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10 }, // 53 ,
    { 0x00, 0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, 0x00 }, // 54 +
    { 0x00, 0x08, 0x1E, 0x28, 0x1C, 0x0A, 0x3C, 0x08 }, // 55 $
    // 8x user defined (56-63)
    { 0x00, 0x14, 0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x14 }, // 56
    { 0x00, 0x14, 0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x14 }, // 57
    { 0x00, 0x14, 0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x14 }, // 58
    { 0x00, 0x14, 0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x14 }, // 59
    { 0x00, 0x14, 0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x14 }, // 60
    { 0x00, 0x14, 0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x14 }, // 61
    { 0x00, 0x14, 0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x14 }, // 62
    { 0x00, 0x14, 0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x14 }  // 63
  },
  // block definitions
  { {    0,    0,    0,    0,    0,    0,    0,    0 }, //  0 (space)
    { 0x03, 0x03, 0x03, 0x03,    0,    0,    0,    0 }, //  1
    { 0x1C, 0x1C, 0x1C, 0x1C,    0,    0,    0,    0 }, //  2
    { 0x1F, 0x1F, 0x1F, 0x1F,    0,    0,    0,    0 }, //  3
    { 0xE0, 0xE0, 0xE0, 0xE0,    0,    0,    0,    0 }, //  4
    { 0xE3, 0xE3, 0xE3, 0xE3,    0,    0,    0,    0 }, //  5
    { 0xFC, 0xFC, 0xFC, 0xFC,    0,    0,    0,    0 }, //  6
    { 0xFF, 0xFF, 0xFF, 0xFF,    0,    0,    0,    0 }, //  7
    {    0,    0,    0,    0, 0x03, 0x03, 0x03, 0x03 }, //  8
    { 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 }, //  9
    { 0x1C, 0x1C, 0x1C, 0x1C, 0x03, 0x03, 0x03, 0x03 }, // 10
    { 0x1F, 0x1F, 0x1F, 0x1F, 0x03, 0x03, 0x03, 0x03 }, // 11
    { 0xE0, 0xE0, 0xE0, 0xE0, 0x03, 0x03, 0x03, 0x03 }, // 12
    { 0xE3, 0xE3, 0xE3, 0xE3, 0x03, 0x03, 0x03, 0x03 }, // 13
    { 0xFC, 0xFC, 0xFC, 0xFC, 0x03, 0x03, 0x03, 0x03 }, // 14
    { 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x03, 0x03, 0x03 }, // 15
    {    0,    0,    0,    0, 0x1C, 0x1C, 0x1C, 0x1C }, // 16
    { 0x03, 0x03, 0x03, 0x03, 0x1C, 0x1C, 0x1C, 0x1C }, // 17
    { 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C }, // 18
    { 0x1F, 0x1F, 0x1F, 0x1F, 0x1C, 0x1C, 0x1C, 0x1C }, // 19
    { 0xE0, 0xE0, 0xE0, 0xE0, 0x1C, 0x1C, 0x1C, 0x1C }, // 20
    { 0xE3, 0xE3, 0xE3, 0xE3, 0x1C, 0x1C, 0x1C, 0x1C }, // 21
    { 0xFC, 0xFC, 0xFC, 0xFC, 0x1C, 0x1C, 0x1C, 0x1C }, // 22
    { 0xFF, 0xFF, 0xFF, 0xFF, 0x1C, 0x1C, 0x1C, 0x1C }, // 23
    {    0,    0,    0,    0, 0x1F, 0x1F, 0x1F, 0x1F }, // 24
    { 0x03, 0x03, 0x03, 0x03, 0x1F, 0x1F, 0x1F, 0x1F }, // 25
    { 0x1C, 0x1C, 0x1C, 0x1C, 0x1F, 0x1F, 0x1F, 0x1F }, // 26
    { 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F }, // 27
    { 0xE0, 0xE0, 0xE0, 0xE0, 0x1F, 0x1F, 0x1F, 0x1F }, // 28
    { 0xE3, 0xE3, 0xE3, 0xE3, 0x1F, 0x1F, 0x1F, 0x1F }, // 29
    { 0xFC, 0xFC, 0xFC, 0xFC, 0x1F, 0x1F, 0x1F, 0x1F }, // 30
    { 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0x1F, 0x1F, 0x1F }, // 31
    {    0,    0,    0,    0, 0xE0, 0xE0, 0xE0, 0xE0 }, // 32
    { 0x03, 0x03, 0x03, 0x03, 0xE0, 0xE0, 0xE0, 0xE0 }, // 33
    { 0x1C, 0x1C, 0x1C, 0x1C, 0xE0, 0xE0, 0xE0, 0xE0 }, // 34
    { 0x1F, 0x1F, 0x1F, 0x1F, 0xE0, 0xE0, 0xE0, 0xE0 }, // 35
    { 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0 }, // 36
    { 0xE3, 0xE3, 0xE3, 0xE3, 0xE0, 0xE0, 0xE0, 0xE0 }, // 37
    { 0xFC, 0xFC, 0xFC, 0xFC, 0xE0, 0xE0, 0xE0, 0xE0 }, // 1C
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xE0, 0xE0, 0xE0 }, // 39
    {    0,    0,    0,    0, 0xE3, 0xE3, 0xE3, 0xE3 }, // 40
    { 0x03, 0x03, 0x03, 0x03, 0xE3, 0xE3, 0xE3, 0xE3 }, // 41
    { 0x1C, 0x1C, 0x1C, 0x1C, 0xE3, 0xE3, 0xE3, 0xE3 }, // 42
    { 0x1F, 0x1F, 0x1F, 0x1F, 0xE3, 0xE3, 0xE3, 0xE3 }, // 43
    { 0xE0, 0xE0, 0xE0, 0xE0, 0xE3, 0xE3, 0xE3, 0xE3 }, // 44
    { 0xE3, 0xE3, 0xE3, 0xE3, 0xE3, 0xE3, 0xE3, 0xE3 }, // 45
    { 0xFC, 0xFC, 0xFC, 0xFC, 0xE3, 0xE3, 0xE3, 0xE3 }, // 46
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xE3, 0xE3, 0xE3 }, // 47
    {    0,    0,    0,    0, 0xFC, 0xFC, 0xFC, 0xFC }, // 48
    { 0x03, 0x03, 0x03, 0x03, 0xFC, 0xFC, 0xFC, 0xFC }, // 49
    { 0x1C, 0x1C, 0x1C, 0x1C, 0xFC, 0xFC, 0xFC, 0xFC }, // 50
    { 0x1F, 0x1F, 0x1F, 0x1F, 0xFC, 0xFC, 0xFC, 0xFC }, // 51
    { 0xE0, 0xE0, 0xE0, 0xE0, 0xFC, 0xFC, 0xFC, 0xFC }, // 52
    { 0xE3, 0xE3, 0xE3, 0xE3, 0xFC, 0xFC, 0xFC, 0xFC }, // 53
    { 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC }, // 54
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFC, 0xFC, 0xFC }, // 55
    {    0,    0,    0,    0, 0xFF, 0xFF, 0xFF, 0xFF }, // 56
    { 0x03, 0x03, 0x03, 0x03, 0xFF, 0xFF, 0xFF, 0xFF }, // 57
    { 0x1C, 0x1C, 0x1C, 0x1C, 0xFF, 0xFF, 0xFF, 0xFF }, // 58
    { 0x1F, 0x1F, 0x1F, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF }, // 59
    { 0xE0, 0xE0, 0xE0, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF }, // 60
    { 0xE3, 0xE3, 0xE3, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF }, // 61
    { 0xFC, 0xFC, 0xFC, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF }, // 62
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }  // 63 (solid)
} };

/* Amiga-ball is:
    ........
    ...#.#..
    ..#.#.#.
    .#.#.#.#
    ..#.#.#.
    .#.#.#.#
    ..#.#.#.
    ...#.#.. */

/* block definitions (arcadia.txt is WRONG! compare against UVI manual!):
     22211100
     22211100
     22211100
     22211100
     55544433
     55544433
     55544433
     55544433 */

/* This is a faithful transcription of the Emulator 2001 algorithm into
   a table of results. */
MODULE UBYTE dma[2][33] =
{ {  // low-res
     0xF0, // raster   0
     0xF0, // raster   8 (unused)
     0xF1, // raster  16
     0xF1, // raster  24 (unused)
     0xF2, // raster  32
     0xF2, // raster  40 (unused)
     0xF3, // raster  48
     0xF3, // raster  56 (unused)
     0xF4, // raster  64
     0xF4, // raster  72 (unused)
     0xF5, // raster  80
     0xF5, // raster  88 (unused)
     0xF6, // raster  96
     0xF6, // raster 104 (unused)
     0xF7, // raster 112
     0xF7, // raster 120 (unused)
     0xF8, // raster 128
     0xF8, // raster 136 (unused)
     0xF9, // raster 144
     0xF9, // raster 152 (unused)
     0xFA, // raster 160
     0xFA, // raster 168 (unused)
     0xFB, // raster 176
     0xFB, // raster 184 (unused)
     0xFC, // raster 192
     0xFC, // raster 200 (unused)
     0xFD, // raster 208 Sense line turned on
     0xFD, // raster 216 (unused)
     0xFD, // raster 224
     0xFD, // raster 232 (unused)
     0xFD, // raster 240
     0xFD, // raster 248 (unused)
     0xFD  // raster 256
}, // high-res
{    0xF0, // raster   0
     0xF1, // raster   8
     0xF2, // raster  16
     0xF3, // raster  24
     0xF4, // raster  32
     0xF5, // raster  40
     0xF6, // raster  48
     0xF7, // raster  56
     0xF8, // raster  64
     0xF9, // raster  72
     0xFA, // raster  80
     0xFB, // raster  88
     0xFC, // raster  96
     0xF0, // raster 104
     0xF1, // raster 112
     0xF2, // raster 120
     0xF3, // raster 128
     0xF4, // raster 136
     0xF5, // raster 144
     0xF6, // raster 152
     0xF7, // raster 160
     0xF8, // raster 168
     0xF9, // raster 176
     0xFA, // raster 184
     0xFB, // raster 192
     0xFC, // raster 200
     0xFD, // raster 208 Sense line turned on
     0xFD, // raster 216
     0xFD, // raster 224
     0xFD, // raster 232
     0xFD, // raster 240
     0xFD, // raster 248
     0xFD  // raster 256
} };

#ifdef AMIGA
MODULE UWORD a_keypads[2][20 + 1] =
{ { SCAN_SPACEBAR,
    SCAN_A1, SCAN_A2, SCAN_A3,
    SCAN_Q,  SCAN_W,  SCAN_E,
    SCAN_A,  SCAN_S,  SCAN_D,
    SCAN_Z,  SCAN_X,  SCAN_C,
    SCAN_A4, SCAN_R,  SCAN_F,  SCAN_V,
    SCAN_I , SCAN_K,  SCAN_J,  SCAN_L
  },
  /* ( ) / *
     7 8 9 -
     4 5 6 +
     1 2 3 E
     -0- . n */
  { SCAN_N0,
    SCAN_OB, SCAN_CB, SCAN_SL,
    SCAN_N7, SCAN_N8, SCAN_N9,
    SCAN_N4, SCAN_N5, SCAN_N6,
    SCAN_N1, SCAN_N2, SCAN_N3,
    SCAN_AS, SCAN_MI, SCAN_PL, SCAN_NE,
    SCAN_UP, SCAN_DOWN, SCAN_LEFT, SCAN_RIGHT
} };
#endif

#ifdef WIN32
MODULE UWORD a_keypads[2][20 + 1] =
{ { SCAN_SPACEBAR,
    SCAN_A1, SCAN_A2, SCAN_A3,
    SCAN_Q,  SCAN_W,  SCAN_E,
    SCAN_A,  SCAN_S,  SCAN_D,
    SCAN_Z,  SCAN_X,  SCAN_C,
    SCAN_A4, SCAN_R,  SCAN_F,  SCAN_V,
    SCAN_I , SCAN_K,  SCAN_J,  SCAN_L
  },
  /* N / * -
     7 8 9 +
     4 5 6 +
     1 2 3 E
     -0- . n */
  { SCAN_N0,
    SCAN_NL, SCAN_SL, SCAN_AS,
    SCAN_N7, SCAN_N8, SCAN_N9,
    SCAN_N4, SCAN_N5, SCAN_N6,
    SCAN_N1, SCAN_N2, SCAN_N3,
    SCAN_MI, SCAN_PL, SCAN_NE, SCAN_ND,
    SCAN_UP, SCAN_DOWN, SCAN_LEFT, SCAN_RIGHT
} };
#endif
